c     -----------------------------------------------------------------LOADCMP
      subroutine loadcmp
      character*1 ltype(8)
      double precision rdis
      common /andat/ rdis,kswt,kdis,kfrc,ktmp,khdr,kseis,keig,nrdof(2)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c.....checks for the specified load components
c.....Set all the load switches to zero.
c.....          Last modifications Sept.08/1993/Sudip S.B./Ecole Polytechnique
c
      call izero (rdis,11)
c.....Check for eigen anlysis request
      call find ('EIGN',kg)
      if (kg .ne. 0) then
         keig=0
      else
         call free
         call freei ('N',keig,1)
         write (not,4003) keig
      endif
c.....Reading the specified load components
      call find ('LOAD',kl)
      if (kl .ne. 0) then
         write (ntm,1000)
         write (not,1000)
         return
      else
         continue
      endif
c.....Check for specified load components
      call free
      call freeh(' ',ltype,1,8)
c.....Check for self weight
      do 100 i=1,8
         if (ltype(i) .ne. 'S') go to 100
            kswt=1
            write (not,1001)
            write (ntm,1001)
            go to 110
  100 continue
  110 continue
c.....Check for pore-pressure effects
c      do 150 i=1,8
c         if (ltype(i) .ne. 'U') go to 150
c            khdr=-1
c            write (not,2008)
c            write (ntm,2008)
c            go to 220
c  150 continue
c.....Check for hydrostatic pressure
      do 200 i=1,8
         if (ltype(i) .ne. 'H') go to 200
            khdr=1
            write (not,1002)
            write (ntm,1002)
            go to 220
  200 continue
c
  220 continue
c
c.....Check for temperature load
      do 300 i=1,8
         if (ltype(i) .ne. 'T') go to 300
            ktmp=1
            write (not,1003)
            write (ntm,1003)
            go to 330
  300 continue
  330 continue
c.....Check for specified forces
      do 400 i=1,8
         if (ltype(i) .ne. 'P') go to 400
            kfrc=1
            write (not,1004)
            write (ntm,1004)
            go to 440
  400 continue
  440 continue
c.....Check for seismic load
      do 500 i=1,8
         if (ltype(i) .ne. 'E') go to 500
             kseis=1
             write (not,1005)
             write (ntm,1005)
             go to 800
  500 continue
c.....Check for specified displacements
      do 600 i=1,8
         if (ltype(i) .ne. 'D') go to 600
            kdis=1
            write (not,1006)
            write (ntm,1006)
            go to 800
  600 continue
c.....check for specified relative displacement control parameter
      do 700 i=1,8
         if (ltype (i) .ne. 'R') go to 700
            kdis=-1
            write (not,1007)
            write (ntm,1007)
            go to 800
  700 continue
c
  800 continue
c
 1000 format (//10x,'NO LOADS HAVE BEEN SPECIFIED')
 1001 format (/' Self weight is one of the load components')
 1002 format (/' Hydrostatic pressure is one of the load components')
 1003 format (/' Temperature is one of the load components')
 1004 format (/' Specified nodal forces is one of the load components')
 1005 format (/' ** Seismic analysis requested **')
 1006 format (/' ** Displacement control analysis requested **')
 1007 format(/' ** Relative displacement control analysis requested **')
c
c 2008 format (/' Pore-pressure is a specified load component')
c
 4003 format (//'** Number of eigen values requested is:',i3/
     +' 0 means no eigen solution',/,'>0 means the specified no. of',
     +' values will be computed only at the beginning of solution',
     +/'<0 means the first value will be computed at the specified',
     +' step interval')
c
      return
      end
c     -----------------------------------------------------------------LOADS
      subroutine loads (ndatam,propma,ndof,iele,dmat,f,dummy,eres,tdat,
     +icode,idat,coord,itmp,kdead,axgrv,windo,porel,bdat,nck,lmdat,
     +ekdat)
      implicit double precision (a-h,o-z)
      dimension propma(1),ndof(1),iele(1),dmat(1),f(1),dummy(1),eres(1),
     +tdat(1),icode(1),idat(1),coord(1),itmp(1),windo(1),
     +porel(1),bdat(1),nck(1),lmdat(1),ekdat(1)
c
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /andat/ rdis,kswt,kdis,kfrc,ktmp,khdr,kseis,keig,nrdof(2)
      common /bacup/ nvec,imass,idead,iep0,ifalse(8)
      common /crack/ rtn,ftol,icrack,ks,nlar,ncrk,ncel,mxk,ipd,ipor,ndt
      common /waterf/ wli,wlf,dwl,uw,cwl,nwet,nhdr,iwl
c
c.....This subroutine assembles non-seismic load components
c
c                              Sudip S. Bhattacharjee/November 19,1991/McGill
c.....          Last modifications Sept.08/1993/Sudip S.B./Ecole Polytechnique
c
      call izero (wli,13)
      kdead=0
c.....read specified loads and/or displacements for incremental static analysis
      if (kseis .eq. 0) call loadpd (f,ndof,windo)
c
      if (kswt .ne. 0  .or.  keig .ne. 0  .or. kseis .ne. 0) then
         write (not,1003) 
         call slfwt (ndatam,propma,ndof,iele,f,dummy,kswt,keig,kseis,
     +   kdead,axgrv,windo)
         call izero (dummy,2*numnp)
      endif
c.....Reservoir information
      kpor=0
      if (khdr .ne. 0) call hydro (coord,itmp,khdr,neq,numel,numnp,
     +windo,kpor,rdis,ndatam,propma,nummat,tdat,ipor,kseis,kfrc)
c.....the unit weight propma(3,mat) has been destroyed in HYDRO***********
c.....Check for hydrostatic pressure and assemble it to global load vector
c      if (khdr .eq. 1  .and.  iwl .ne. nwet) then
      if (khdr .ne. 0  .and.  iwl .ne. nwet) then
          write (not,1004)
          write (ntm,1004)
          call hfors (f,ndof,coord,itmp,hforce)
          write (not,3004) hforce
      endif
c.....Assemble the pore-water pressure in the global load vector
  120 continue
      if (khdr .eq. -1) then
          write (not,2004)
          call pore (ndof,iele,f,dummy,khdr,kpor,ndatam,propma,porel,
     +    ipor)
      endif
      if (khdr .eq. 0) then
         nhdr=0
         ipor=0
      else
          kdead=1
      endif
c.....Check for the pore-pressure effects inside cracks
c      if (ipor .ne. 0) then
c.........the job of pormax has been done in ASSEMPR under PORE
c         call pormax (dummy,coord,porel,iele)
c........correct the pore pressure for ORTHO elements if (ipor .ne. 0)
         dps=0.d0
      if (ipor .eq. 1  .and.  ncel .gt. 0) then
         call orthopor (porel,idat,icode,coord,iele,nck,ncrk,ncel,
     +   propma,ndatam,ndt)
         call crkpor (porel,bdat,iele,icode,idat,ndof,f,nck,ncel,ndt)
      endif
      call izero (dummy,2*numnp)
      khdr=nhdr
      if (khdr .eq. 0) dwl=0.d0
c.....Assemble the specified concentrated forces to the dead load vector
      if (kseis .ne. 0  .and.  kfrc .eq. 1) then 
         call load (f,ndof,kfrc,'FRCE','P')
         kdead=1
      else
         continue
      endif
c
      nvec=nvec+1
      idead=nvec
      call bakup (f(1),neq,idead,windo)
c.....Check for temperature load
      if (ktmp .eq. 0) go to 300
         write (not,1005)
         call tload (ndof,iele,dmat,f,dummy,eres,tdat,icode,idat,ncel,
     +   ndt)
         kdead=1
  300 continue
      if (nbms .ne. 0) call adpstrs (f(1),lmdat(1),ekdat(1),kdead,nbms)
c
c      nvec=nvec+1
      iep0=1
      ndata=4*numel
      call bakup (eres,ndata,iep0,windo)
c
 1001 format (//10x,'NO LOADS HAVE BEEN SPECIFIED')
 1002 format (//13x,' READING SPECIFIED LOAD COMPONENTS')
 1003 format (/8x,' developing the self weight vector')
 1004 format (/' ** Assembling the initial reservoir pressure',
     +' applied to the upstream face **')
 3004 format (/' The total horizontal water thrust on the upstream face',
     +' is:',e13.7)
 2004 format (/8x,' adding the pore-pressure to the global load vector')
 1005 format (/' Assembling the temperature load')
 4003 format (//'** Number of eigen values requested is:',i3)
c
      return
      end
c     -------------------------------------------------------------------LOADPD
      subroutine loadpd (f,ndof,windo)
      implicit double precision (a-h,o-z)
      dimension f(1),ndof(1),windo(1)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /andat/ rdis,kswt,kdis,kfrc,ktmp,khdr,kseis,keig,nrdof(2)
      common /bacup/ nvec,imass,idead,iep0,ifc,idis,idisp,irest,ifals(4)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
      if (kfrc .eq. 0) go to 100
         call load (f,ndof,kfrc,'FRCE','P')
         nvec=nvec+1
         ifc=nvec
         call bakup (f,neq,ifc,windo)
         call izero (f,neq*2) 
  100 continue
      if (kdis .eq. -1) then
         kdis=0
         call redisp (rdis,nrdof(1),nrdof(2),ndof)
      else
         continue
      endif
      if (kdis .eq. 0) go to 200
         call load (f,ndof,kdis,'DISP','D')
         nvec=nvec+1
         idis=nvec
         call bakup (f,neq,idis,windo)
         call izero (f,neq*2) 
  200 continue
      if (kdis .eq. 0) numeqn=neq
c
      return
      end
c     ---------------------------------------------------------------------LOAD
      subroutine load (f,ndof,kstep,baner,type)
      implicit double precision (a-h,o-z)
      character*4 baner
      character*1 type,blnk,test
      dimension f(1),ndof(3,1),data(3),itmp(3)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      data blnk /' '/
c
c.....This routine reads the specified load or displacement components
c
c                               Sudip S. Bhattacharjee/February 19,1992/McGill
c                                             modified August   18,1992/McGill
      call find (baner,kh)
      if (kh .ne. 0) then
         write (ntm,1001) baner
         write (not,1001) baner
         kstep=0
         return
      else
         continue
      endif
c.....Input the specified force/displacement increments
      write (not,2001) baner
      k=0
      call free
      call freei ('I',kstep,1)
  100 call free
      call freeh (' ',test,1,1)
      if (test .eq. blnk) go to 300
      call freei('N',node,1)
      call izero (data,6)
      call freer (type,data,3)
      idof=ndof(1,node)
      jdof=ndof(2,node)
      ldof=ndof(3,node)
      f(idof)=f(idof)+data(1)
      f(jdof)=f(jdof)+data(2)
      f(ldof)=f(ldof)+data(3)
      k=k+1
      write (not,2002) node,data
      itmp(1)=0
      call freei ('G',itmp,3)
      i1=itmp(1)
      if (i1 .eq. 0) go to 100
         i2=itmp(2)
         inc=itmp(3)
         do 220 i=i1,i2,inc
            idof=ndof(1,i)
            jdof=ndof(2,i)
            ldof=ndof(3,i)
            f(idof)=f(idof)+data(1)
            f(jdof)=f(jdof)+data(2)
            f(ldof)=f(ldof)+data(3)
            k=k+1
            write (not,2002) i,data
  220    continue
         go to 100
  300 continue
      write (not,3001) k,baner
      write (ntm,3001) k,baner
c      nvec=nvec+1
c      ibac=nvec
c      call bakup (f(1),neq,ibac)
c      call izero (f(1),2*neq)
c
 1001 format (//10x,'*** Required card ',a4,' missing ***')
 2001 format (//' Specified incremental ',a4,' in the system:'/
     +'Node No.',10x,'Component_x',10x,'Component_y',10x,'Component_xy')
 2002 format (i6,12x,e13.5,9x,e13.5,10x,e13.5)
 3001 format (/ ' Total',i3, ' nodal ',a4,' specified')
c
      return
      end
c     ------------------------------------------------------------------REDISP
      subroutine redisp (rdicre,i1dof,i2dof,ndof)
      double precision rdicre
      dimension ndof(3,1),nodes(2)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c     Reads the relative displacement control parameter and the key dofs.
c                              Sudip S.B./McGill/June 28,1992
      call find ('RDIS',kr)
      if (kr .ne. 0) then
         write (ntm,1001)
         write (not,1001)
         return
      else
         continue
      endif
c.....Read the control parameters
      call free
      call freer ('I',rdicre,1)
      call freei ('N',nodes,2)
      call freei ('D',icomp,1)
      i1dof=ndof(icomp,nodes(1))
      i2dof=ndof(icomp,nodes(2))
      write (not,1002) nodes(1),nodes(2),icomp,rdicre
c
 1001 format (//10x,'RELATIVE DISPLACEMENT DATA NOT FOUND')
 1002 format (//10x,' SPECIFIED RELATIVE DISPLACEMENT CONTROL',
     +' PARAMETERS:'/10X,' Specified nodes:',2i5/10x,' Specified',
     +' displacement component [1=x comp, 2=y comp.]',i5/10x,
     +' Displacement increment at each step:',f10.5)
c
      return
      end
c     -------------------------------------------------------------------SLFWT
      subroutine slfwt (ndatam,propma,ndof,iele,f,dummy,kswt,keig,kseis,
     +kdead,axgrv,windo)
      implicit double precision (a-h,o-z)
      dimension propma(ndatam,1),ndof(3,1),iele(5,1),f(1),dummy(1),
     +bmat(36),shp(16),p(4),windo(1)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /gauss/ sg(4),tg(4),wg(4),nint
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /bacup/ nvec,imass,idead,iep0,ifalse(8)
c.....This subroutine generates the self weight vector
      nnode=4
      do 300 n=1,numel
         mat=iele(5,n)
         uwt=propma(3,mat)
         call izero (p,8)
         read (nt8,rec=n) bmat,shp
c........Compute matrix at each integration point
         Do 200 k=1,4
c...........For each node I compute contribution
            dwt=uwt*bmat(k*9)
            kk=(k-1)*4
            do 100 i=1,nnode
               p(i)=p(i)+dwt*shp(kk+i)
  100       continue
  200    continue
         do 250 i=1,4
            node=iele(i,n)
            dummy(node)=dummy(node)+p(i)
  250    continue
  300 continue
c
      if (keig .eq. 0  .and.  kseis .eq. 0) go to 400
      call mass (ndof,dummy,f,axgrv)
      nvec=nvec+1
      imass=nvec
      call bakup (f(1),neq,imass,windo)
      call izero (f(1),neq*2)
400   continue
      if (kswt .eq. 0) go to 500
      kdead=1
      tweit=0.d0
      do 410 n=1,numnp
         ieqn=ndof(2,n)
         f(ieqn)=f(ieqn)-dummy(n)
         tweit=tweit+dummy(n)
  410 continue
c.....Total weight taken into account
      tot=0.0
      do 420 i=1,neq
         tot=tot-f(i)
  420 continue
c.....Percent of weight not taken into account
      ploss=(tweit-tot)/tweit*100.0
      write (not,1001) tweit,ploss
  500 continue
c
 1001 format (/10x,' Total weight of the structure:',e13.6/
     +11x,'Percent loss due to finite element discretization:',f6.2,'%')
c
      return
      end
c     -------------------------------------------------------------------TLOAD
      subroutine tload (ndof,iele,d0,f,tempn,eres,tdat,icode,idat,ncel,
     +ndt)
      implicit double precision (a-h,o-z)
      dimension ndof(1),iele(5,1),d0(4,1),f(1),tempn(1),eres(4,1),
     +tdat(2,1),bmat(36),shp(16),icode(1),idat(1),dmat(6)
      common /cntrl/ nummat,numnp,numel,nbms,nter,numeqn,mband,nsto,neq
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     Adds the temperature load to the static load vector and computes the
c     unrestrained element strains
c
      kt=0
      call find ('TEMP',kt)
      if (kt .ne. 0) then
         write (not,1001)
         write (ntm,1001)
         return
      else
         continue
      endif
      call free
      call freer ('S',sai,1)
      do 100 i=1,nummat
         call free
         call freei ('M',mat,1)
         call freer ('A',alpha,1)
         call freer ('T',tref,1)
         tdat(1,mat)=alpha
         tdat(2,mat)=tref
  100 continue
c
      write (not,1002) sai,(j,(tdat(i,j),i=1,2),j=1,nummat)
      write (not,1003)
      write (ntm,1003)
      call fopen (ntr,'tmp')
      read (ntr) (tempn(i),i=1,numnp)
      call fclose (ntr)
c
      fact=1.0-sai
      do 200 i=1,nummat
         tdat(1,i)=tdat(1,i)*fact
  200 continue
c
      do 300 n=1,numel
         mat=iele(5,n)
            call copr (d0(1,mat),dmat(1),4)
            dmat(5)=0.d0
            dmat(6)=0.d0
         read (nt8,rec=n) bmat,shp
         call addt (tdat(1,mat),tdat(2,mat),tempn,dmat(1),bmat(1),
     +   shp(1),f,eres(1,n),iele(1,n),ndof)
c
  300 continue
c
 1001 format (//' Temperature stress analysis requested, but the data',
     +' card TEMP is missing in the input data file')
 1002 format (//' SPECIFIED TEMPERATURE STRESS ANALYSIS DATA:'/
     +/' Long term relaxation factor (sai)=',f12.5//' Material data:',
     +/' Material no.',10x,'Coef. of thermal expansion',10x,'reference',
     +' temperature'/(i7,16x,e23.5,14x,f18.5))
 1003 format (/' The nodal temperature data is expected to be in the',
     +' file named'/' with an extension of ''tmp''')
c
      return
      end
c     ---------------------------------------------------------------------ADDT
      subroutine addt (alpha,tref,tempn,dmat,bmat,shp,f,eps0,iele,ndof)
      implicit double precision (a-h,o-z)
      dimension tempn(1),dmat(6),bmat(36),shp(16),f(1),eps0(4),iele(4),
     +ndof(1),ds(3)
c     called by tload
      do 500 k=1,4
         kk=(k-1)*4
         temp=0.d0
         do 100 i=1,4
            temp=temp+shp(kk+i)*tempn(iele(i))
  100    continue
         dtemp=temp-tref
         deps=alpha*dtemp
         eps0(k)=deps
         ds(1)=(dmat(1)+dmat(2))*deps
         ds(2)=ds(1)
         ds(3)=0.d0
c
         kk=(k-1)*9+1
         call restor (ds,f,bmat(kk),bmat(kk+8),iele,ndof)
  500 continue
c
      return
      end
c     -----------------------------------------------------------------RESTOR
      subroutine restor (stres,fr,bmat,xjac,iele,ndof)
      implicit double precision (a-h,o-z)
      dimension stres(3),fr(1),bmat(2,4),iele(4),ndof(3,1),ds(3),dp(2,4)
c
c     Computes the restoring force of an element adds to the global vector f
c
      do 100 i=1,3
         ds(i)=stres(i)*xjac
  100 continue
c
      do 320 i=1,4
         dp(1,i)=bmat(1,i)*ds(1)+bmat(2,i)*ds(3)
         dp(2,i)=bmat(2,i)*ds(2)+bmat(1,i)*ds(3)
  320 continue
c
      do 330 i=1,4
         node=iele(i)
         idof=ndof(1,node)
         jdof=ndof(2,node)
         fr(idof)=fr(idof)+dp(1,i)
         fr(jdof)=fr(jdof)+dp(2,i)
  330 continue
c
      return
      end
c     --------------------------------------------------------------------EQDAT
      subroutine eqdat (gacce,llast,mtot,axgrv)
      implicit double precision (a-h,o-z)
      dimension gacce(1)
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
      common /andat/ rdis,kswt,kdis,kfrc,ktmp,khdr,kseis,keig,mrdof(2)
      common /seismic/ am,bk,apha,bta,gama,dt,tt,ddat,dme,dmf,ic,kpd,kac
c
c     Reads the dynamic analysis parameters and ground motion data for seismic
c     analysis
c                                Sudip S.B./ January 04,1992/ McGill
c
      call izero (am,23)
      ke=0
      call find ('SEIS',ke)
      if (ke .ne. 0) then
         write (not,1001)
         write (ntm,1001)
         kseis=0
         return
      else
         continue
      endif
      dme=1.d0
      dmf=1.d0
      kpd=0
      kac=0
      call free
      call freer ('A',apha,1)
      call freer ('B',bta,1)
      call freer ('G',gama,1)
      call freer ('D',dt,1)
      call freer ('T',tt,1)
      call freer ('M',am,1)
      call freer ('K',bk,1)
      call freer ('S',dme,1)
      call freer ('F',dmf,1)
      call freei ('X',kac,1)
      if (bk .ne. 0.d0) call freei ('C',kpd,1)
c
      call free
      call freei ('E',ic,1)
      if (ic .ne. 0) go to 100
      write (not,1002)
      kseis=0
      return
c
  100 continue
      ampl=1.d0
      call freei ('N',ndata,1)
      call freer ('I',ddat,1)
      call freer ('A',ampl,1)
      if (ic .eq. 1) then
         write (not,1003) 
         llast=llast+ndata*2
      else
         write (not,1004)
         llast=llast+ndata*4
         ic=ndata+1
      endif
      if (llast .gt. mtot) stop ' *** INSUFFICIENT CORE STORAGE : 7 ***'
c
      dnum=dble(ndata-1)
      tmax=dnum*ddat
      if (tt .gt. tmax) tt=tmax
c
      write(not,2001)apha,bta,gama,dt,tt,am,bk,dme,dmf,ddat,ampl,kpd,kac
c
      call eqread (gacce(1),ndata,axgrv,ampl)
c      write (not,*) (gacce(i),i=1,ndata)
      if (ic .eq. 1) return
      call eqread (gacce(ic),ndata,axgrv,ampl)
c
 1001 format (//' Seismic analysis requested, but the data card SEIS',
     +' is missing in the input file')
 1002 format (//' Specified ground motion components:       None')
 1003 format (//' Specified ground motion components: Horizontal only')
 1004 format (//' Specified ground motion components: Horizontal and',
     +' Vertical both')
 2001 format (//' THE DYNAMIC ANALYSIS PARAMETERS ARE AS FOLLOWS:',/
     +/' Time integration parameter (alpha)          :',f10.5,
     +/' Time integration parameter (beta )          :',f10.5,
     +/' Time integration parameter (gama)           :',f10.5,
     +/' Time integration step      (dt)             :',f10.5,
     +/' Total time of integration  (tt)             :',f10.5,
     +/' Damping coefficient a0 (C=a0M+a1K)          :',f10.5,
     +/' Damping coefficient a1 (C=a0M+a1K)          :',f10.5,
     +/' Strength magnification factor (DMFe)        :',f10.5,
     +/' Fracture energy magnification factor (DMFf) :',f10.5,
     +/' Time interval of specified ground motion    :',f10.5,
     +/' Aplification factor for ground acceleration :',f10.5,
     +/' Code for updating the damping matrix        :',i10,
     +/' Code for acceleration computation           :',i10)
c
      return
      end
c     -------------------------------------------------------------------EQREAD
      subroutine eqread (gacce,ndata,axgrv,ampl)
      double precision gacce(ndata),axgrv,ampl,fact
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
      read (nin,1001) (gacce(i),i=1,ndata)
 1001 format (10f8.0)
c
      fact=ampl*axgrv
      do 100 i=1,ndata
         gacce(i)=gacce(i)*fact
  100 continue
c
      return
      end
c     ------------------------------------------------------------------ADPSTRS
      subroutine adpstrs (f,lmdat,ekdat,kdead,nbms)
      implicit double precision (a-h,o-z)
      dimension f(1),lmdat(8,1),ekdat(64,1),bprop(10),lm(8)
c
      common /iolist/ ntm,ntr,nin,not,nsp,nfl,nt7,nt8,nt9,nt10,nt11(4)
c
c     assembles the inital prestressing forces of beam/truss elements
c     in the global load vector
c                                Sudip S.B./ January 14,1994/ Ecole
c
      ipstrs=0
      do 100 n=1,nbms
         call copyr (bprop(1),ekdat(37,n),10)
         if (bprop (5) .ne. 0.d0  .and.  bprop(1) .ne. 0.d0) then
            call copyi (lm(1),lmdat(1,n),8)
            fa=bprop(1)*bprop(5)
            fx=fa*bprop(9)
            fy=fa*bprop(10)
            f(lm(1))=f(lm(1))+fx
            f(lm(2))=f(lm(2))+fy
            f(lm(4))=f(lm(4))-fx
            f(lm(5))=f(lm(5))-fy
            ekdat(47,n)=fx
            ekdat(48,n)=fy
            ipstrs=ipstrs+1
            if (ipstrs .eq. 1) write (not,1000)
            write (not,1001) n,lm(7),lm(8),bprop(5),fa
         endif
  100 continue
      if (ipstrs .eq. 0) then
         write (not,2001)
         write (ntm,2001)
      else
         write (not,2002) ipstrs
         write (ntm,2002) ipstrs
         kdead=1
      endif
c
 1000 format (//'Pstressing forces of the following elements have been',
     +' assembled in the global load vector'//'Beam/truss el. no.',5x,
     +'connecting nodes',5x,'initial stress',5x,'total force')
 1001 format (i15,8x,i7,',',i7,5x,e15.5,2x,e15.5)
 2001 format (//' ** NO PRESTRESSING FORCE HAS BEEN APPLIED **')
 2002 format (//' PSTRESSING FORCES HAVE BEEN APPLIED IN',i6,' BEAM/',
     +'TRUSS ELEMENTS'//'NOTE: The effectively applied prestressing f',
     +'orce will be less than the initally'/'specified values, due to ',
     +'the elastic deformation of the finite element model'/'during app',
     +'lication')
c
      return
      end
 
